/* predict employment with expectations - overall economy
  need more sophisticated way than for manufacturing of doing counterfactual
  expectations */

sort year_q
gen expball2=expbal[_n-2]
gen inter1=expball2*lgdp_rl2
gen inter2=expball2*lcostperladj_rl2
gen inter3=expball2*year_q
reg lempl lgdp_rl2 lcostperladj_rl2 year_q if year<=2003
reg lempl lgdp_rl2 lcostperladj_rl2 expball2 year_q if year<=2003
reg lempl lgdp_rl2 lcostperladj_rl2 expball2 inter1 inter2 year_q if year<=2003
reg lempl lgdp_rl2 lcostperladj_rl2 expball2 inter1 inter2 inter3 year_q if year<=2003

* do in differences, with raw expectations
gen dinter1=expball2*dlgdp_r
gen dinter2=expball2*dlcostperladj_r
sort year_q

tsset,clear
drop timevar
do ~/research/BPEA_recession/statprog/timevar

newey dlempl dlgdp_r dlcostperladj_r if year<=2003,lag(4)
reg dlempl dlgdp_r dlcostperladj_r if year<=2003
predict dlemplhat1
* predict the level
gen lemplhat1=lempl if year<=2003
replace lemplhat1=lemplhat1[_n-1]+dlemplhat1 if lemplhat1==.
.
replace lemplhat1=. if year_q<=2002.75

* with interactions - they are insig
reg dlempl dlgdp_r dlcostperladj_r expball2 dinter1 dinter2 if year<=2003

* so focus on without interactions
newey dlempl dlgdp_r dlcostperladj_r expball2 if year<=2003,lag(4)
reg dlempl dlgdp_r dlcostperladj_r expball2 if year<=2003
predict dlemplhat2

* predict the level
gen lemplhat2=lempl if year<=2003
replace lemplhat2=lemplhat2[_n-1]+dlemplhat2 if lemplhat2==.
.
replace lemplhat2=. if year_q<=2002.75

* do counterfactual where 
* best predictor of expectations is current overall situation
* same R2 levels or diffs, but coeff on current much higher in diffs
* do regs for <=2003, but only do counterfactual from start of boom
* Q1 2005

sort year_q
gen dexpbal=expbal-expbal[_n-1]
*gen dcurrbal=currbal-currbal[_n-1]
reg dexpbal dcurrbal if year<=2003
predict dexpcounter
*drop dcurrbal dexpbal
gen expcounter=expbal if year_q<2005.25
replace expcounter=expcounter[_n-1]+dexpcounter if expcounter==.

* do 2nd set of counterfactuals starting from where were after boom, so
* to say, given where were until then, compare actual/prediction recession
* expectations
gen expcounter2=expbal if year_q<2007.75
replace expcounter2=expcounter2[_n-1]+dexpcounter if expcounter2==.

sort year_q
gen expcounterl2=expcounter[_n-2]

* redo key reg
reg dlempl dlgdp_r dlcostperladj_r expball2 if year<=2003

gen dlemplcounter=_b[_cons]+_b[dlgdp_r]*dlgdp_r+_b[dlcostperladj_r]*dlcostperladj_r+_b[expball2]*expcounterl2
gen lemplcounter=lempl if year<=2003
replace lemplcounter=lemplcounter[_n-1]+dlemplcounter if lemplcounter==.
replace lemplcounter=. if year_q<2005.25

label var lempl "actual L"
label var lemplhat1 "predict changes w/o expectations"
label var lemplhat2 "predict changes w expectations"
label var lemplcounter "counterfactual L changes"
*gr7 lempl lemplhat1 lemplhat2 lemplcounter year_q,c(llll) s(....) xline(2005)

* now check differences in these
gen dlemplb=.
gen dlemplhat1b=.
gen dlemplhat2b=.
gen dlemplcounterb=.
* boom Q3 2005- Q3 2008 (if looking at va varibles, lag 2 quarters)
replace dlemplcounterb=lemplcounter-lemplcounter[_n-12] if year==2008&quarter==3
replace dlemplhat2b=lemplhat2-lemplhat2[_n-12] if year==2008&quarter==3
replace dlemplb=lempl-lempl[_n-12] if year==2008&quarter==3
replace dlemplhat1b=lemplhat1-lemplhat1[_n-12] if year==2008&quarter==3

* bust Q3 2008 - Q3 2009
replace dlemplcounterb=lemplcounter-lemplcounter[_n-4] if year==2009&quarter==3
replace dlemplhat2b=lemplhat2-lemplhat2[_n-4] if year==2009&quarter==3
replace dlemplb=lempl-lempl[_n-4] if year==2009&quarter==3
replace dlemplhat1b=lemplhat1-lemplhat1[_n-4] if year==2009&quarter==3

* recovery Q3 2009 - Q3 2010
replace dlemplcounterb=lemplcounter-lemplcounter[_n-4] if year==2010&quarter==3
replace dlemplhat2b=lemplhat2-lemplhat2[_n-4] if year==2010&quarter==3
replace dlemplb=lempl-lempl[_n-4] if year==2010&quarter==3
replace dlemplhat1b=lemplhat1-lemplhat1[_n-4] if year==2010&quarter==3

label var dlemplb "actual L, relevant changes"
label var dlemplhat1b "predict changes w/o expectations"
label var dlemplhat2b "predict changes w expectations"
label var dlemplcounterb "counterfactual L changes"

* how much missing employment growth in boom is due to expectations?
gen diffb=dlemplcounterb-dlemplhat2b

list dlemplb dlemplhat1b dlemplhat2b dlemplcounterb diffb if year>=2007

* redo using exact boom and bust dates for employment in manufacturing, namely
* boom Q1 2006-Q3 2008
* bust Q3 2008-Q1 2010
* recovery, to extent there is one Q1 2010-Q3 2010
* now check differences in these
gen dlemplc=.
gen dlemplhat1c=.
gen dlemplhat2c=.
gen dlemplcounterc=.
* boom Q1 2006- Q3 2008
replace dlemplcounterc=lemplcounter-lemplcounter[_n-10] if year==2008&quarter==3
replace dlemplhat2c=lemplhat2-lemplhat2[_n-10] if year==2008&quarter==3
replace dlemplc=lempl-lempl[_n-10] if year==2008&quarter==3
replace dlemplhat1c=lemplhat1-lemplhat1[_n-10] if year==2008&quarter==3

* bust Q3 2008 - Q1 2010
replace dlemplcounterc=lemplcounter-lemplcounter[_n-6] if year==2010&quarter==1
replace dlemplhat2c=lemplhat2-lemplhat2[_n-6] if year==2010&quarter==1
replace dlemplc=lempl-lempl[_n-6] if year==2010&quarter==1
replace dlemplhat1c=lemplhat1-lemplhat1[_n-6] if year==2010&quarter==1

* recovery Q1 2010 - Q3 2010
replace dlemplcounterc=lemplcounter-lemplcounter[_n-2] if year==2010&quarter==3
replace dlemplhat2c=lemplhat2-lemplhat2[_n-2] if year==2010&quarter==3
replace dlemplc=lempl-lempl[_n-2] if year==2010&quarter==3
replace dlemplhat1c=lemplhat1-lemplhat1[_n-2] if year==2010&quarter==3

label var dlemplc "actual L, relevant changes"
label var dlemplhat1c "predict changes w/o expectations"
label var dlemplhat2c "predict changes w expectations"
label var dlemplcounterc "counterfactual L changes"

* how much missing employment growth in boom is due to expectations?
gen diffc=dlemplcounterc-dlemplhat2c

list dlemplc dlemplhat1c dlemplhat2c dlemplcounterc diffc if year>=2007

*drop lvax_r-diffc







